/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class ItemNbtCondition
implements Condition<ItemStack> {
    private final NbtPredicate nbt;

    public ItemNbtCondition(NbtPredicate nbt) {
        this.nbt = nbt;
    }

    public static ConditionFactory<ItemStack> factory() {
        return ConditionFactory.withData(ItemNbtCondition::parse);
    }

    public static Result<ItemNbtCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(ItemNbtCondition::parse);
    }

    public static Result<ItemNbtCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optNbt = rootObject.get("nbt").andThen(JsonParseUtils::parseNbtPredicate).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new ItemNbtCondition((NbtPredicate)optNbt.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.nbt.m_57479_(itemStack);
    }
}

